<?php

namespace App\Models;

use DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Membership extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id',
        'membership_type_id',
        'profile_picture',
        'valid_from',
        'valid_to',
        'custom_duration'
    ];

    /**
     * Define a belongs to relationship with the Member model, with a default value.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class)->withDefault();
    }   

    /**
     * Define a belongs to relationship with the MembershipType model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function membership_type()
    {
        return $this->belongsTo(MembershipType::class)->withDefault();;
    }

    /**
     * Define a morph many relationship with the Transaction model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function transactions()
    {
        return $this->morphMany(Transaction::class, 'transactionable');
    }
}